/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear.buffer;

import math.geom2d.Angle2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.buffer.JoinFactory;
import math.geom2d.conic.CircleArc2D;
import math.geom2d.line.LineSegment2D;

public class RoundJoinFactory
implements JoinFactory {
    public CirculinearContinuousCurve2D createJoin(CirculinearElement2D curve1, CirculinearElement2D curve2, double dist) {
        double endAngle;
        double startAngle;
        Point2D center = curve2.getFirstPoint();
        Vector2D direction1 = curve1.getTangent(curve1.getT1());
        Vector2D direction2 = curve2.getTangent(curve2.getT0());
        double angle1 = direction1.getAngle();
        double angle2 = direction2.getAngle();
        double diff = Angle2D.formatAngle(angle2 - angle1);
        if (dist > 0.0 && diff >= Math.PI || dist <= 0.0 && diff <= 1.5707963267948966) {
            Point2D p1 = Point2D.createPolar(center, dist, angle1 - 1.5707963267948966);
            Point2D p2 = Point2D.createPolar(center, dist, angle2 - 1.5707963267948966);
            return new LineSegment2D(p1, p2);
        }
        if (dist > 0.0) {
            startAngle = angle1 - 1.5707963267948966;
            endAngle = angle2 - 1.5707963267948966;
        } else {
            startAngle = angle1 + 1.5707963267948966;
            endAngle = angle2 + 1.5707963267948966;
        }
        startAngle = Angle2D.formatAngle(startAngle);
        endAngle = Angle2D.formatAngle(endAngle);
        double diffAngle = endAngle - startAngle;
        diffAngle = Math.min(diffAngle, Math.PI * 2 - diffAngle);
        if (Math.abs(diffAngle) < 1.0E-10) {
            return new CircleArc2D(center, Math.abs(dist), startAngle, 0.0);
        }
        return new CircleArc2D(center, Math.abs(dist), startAngle, endAngle, dist > 0.0);
    }
}

